package com.example.bytesbee.alphabets.activities.utils;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;

import com.example.bytesbee.alphabets.activities.CommonTTSActivity;
import com.example.bytesbee.alphabets.activities.WebViewBrowserActivity;
import com.example.bytesbee.alphabets.activities.constants.IConstants;
import com.example.bytesbee.alphabets.activities.CommonActivity;

/**
 * @author Prashant
 * @company BytesBee
 * @link http://bytesbee.com/
 */
public class Screens {

    public static void showClearTopScreen(final Context context, final Class<?> cls) {
        final Intent intent = new Intent(context, cls);
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK);
        context.startActivity(intent);
    }

    public static void showCustomScreen(final Context context, final Class<?> cls) {
        final Intent intent = new Intent(context, cls);
        context.startActivity(intent);
        try {
            ((Activity) context).overridePendingTransition(0, 0);
        } catch (Exception e) {
        }
    }

    public static void openWebViewActivity(final Context context, final String title, final String path) {
        Intent intent = new Intent(context, WebViewBrowserActivity.class);
        intent.putExtra(IConstants.EXTRA_NAME, title);
        intent.putExtra(IConstants.EXTRA_LINK, path);
        Utils.sout("webView : " + title);
        context.startActivity(intent);
    }

    public static void openCommonActivity(final Context context, final int[] images, final int[] sounds) {
        Intent intent = new Intent(context, CommonActivity.class);
        intent.putExtra(IConstants.EXTRA_IMAGES, images);
        intent.putExtra(IConstants.EXTRA_SOUNDS, sounds);
        context.startActivity(intent);
    }

    public static void openCommonActivity(final Context context, final int[] images, final String[] sounds) {
        Intent intent = new Intent(context, CommonTTSActivity.class);
        intent.putExtra(IConstants.EXTRA_IMAGES, images);
        intent.putExtra(IConstants.EXTRA_SOUNDS, sounds);
        context.startActivity(intent);
    }
}
